clc
clear all
close all
set(0,'defaultTextInterpreter','latex'); %trying to set the default
set(0,'defaultAxesFontSize',20);
set(0,'defaultAxesFontName','TimesNewRoman');

%% CREAZIONE MATRICE DA TXT
pa=101325; %Pa
Spessore=150;%um
ps=4; %bar 
x0=0;%um
D_foro=8;
test=3;
Dati=['load PattinoC60x30_f' num2str(D_foro) '_' num2str(Spessore) 'um_' num2str(ps) 'bar_x' num2str(x0) '_' num2str(test) '.txt'];
eval(Dati);

Spostamento=['x=PattinoC60x30_f' num2str(D_foro) '_' num2str(Spessore) 'um_' num2str(ps) 'bar_x' num2str(x0) '_' num2str(test) '(:,7);'];
Pressione=['p=PattinoC60x30_f' num2str(D_foro) '_' num2str(Spessore) 'um_' num2str(ps) 'bar_x' num2str(x0) '_' num2str(test) '(:,8)*1e5;'];
Portata=['Q=PattinoC60x30_f' num2str(D_foro) '_' num2str(Spessore) 'um_' num2str(ps) 'bar_x' num2str(x0) '_' num2str(test) '(:,6);'];

eval(Spostamento);
eval(Pressione);
eval(Portata);

P=p+pa;

%Riordina le x 
xi=x(1);
for j=1:length(x)
x(j)=xi-x(j);
end

%Divisione Curve
Qi=1.634; %l/min
[val1, ind1]=min(abs(Q-Qi));

x1=x(1:ind1)*1e-6;
p1=p(1:ind1);
Q1=Q(1:ind1);
P1=p1+pa;

x2=x(ind1:end)*1e-6;
p2=p(ind1:end);
Q2=Q(ind1:end);
P2=p2+pa;
Ps=ps*1e5+pa;

figure
plot(P./Ps,Q,'b','Linewidth',4),hold on,
plot(P1./(ps*1e5+pa),Q1,'ro','Linewidth',4),hold on,
plot(P2./(ps*1e5+pa),Q2,'go','Linewidth',4),hold on,
xlabel('$\frac{P}{P_s}$ (-)'),
ylabel('$Q$ ($\frac{l}{min}$) ANR 20 $^\circ$')
grid on, zoom on
legend('completo','primo tratto','secondo tratto')

%% Analisi tratto lineare
a=D_foro/2*1e-3;            %raggio membrana [m]
E=201e9;                          %Modulo di Young [N/m^2]
nu=0.3;                         %Coeff. di Poisson

ind_P1=P1>=3*1e5;    %filtro tutti i dati con P1<3 bar per considerare solo il tratto lineare delle x
P1=P1(ind_P1);
x1=x1(ind_P1);
[P1max,indm]=max(P1);
x_lin=x1(1:end);

m_q=polyfit(P1,x_lin,1);
retta=polyval(m_q,P1);
Am=pi*a^2;
m=m_q(1);
k_pattino=Am/m;

figure
plot(P1,x_lin,'o',P1,retta,'-','LineWidth',3)
xlabel('$p_{rel.}$ (Pa)'),
ylabel('$x_{laser}$ ($\mu m$)')
grid on, zoom on
legend('sperimentale','teorica')
    
%% Salvataggio
% stringa_k=['k_f' num2str(D_foro) '_s' num2str(Spessore)  '_ps' num2str(ps) '_x' num2str(x0) '_' num2str(test) '=k_pattino;'];
% 
% Salvataggio=['save Calcolo_k_Pattino_f' num2str(D_foro) '_s' num2str(Spessore)  '_ps' num2str(ps) '_x' num2str(x0) '_' num2str(test) ' k_f' num2str(D_foro) '_s' num2str(Spessore)  '_ps' num2str(ps) '_x' num2str(x0) '_' num2str(test)];
% 
% eval(stringa_k)
% eval(Salvataggio)

%% PLOT
% Dati
Sspessore=[50 100 120 150];
ps=4;
x0_precarico=0;
ttest=[1 2 3];
pa=101325;
Dd_foro=[6 8];

for index_foro=1:length(Dd_foro)
dforo=Dd_foro(index_foro);
    for index_Spessore=1:length(Sspessore)
        Sp=Sspessore(index_Spessore);
        for index_Test=1:length(ttest)
            Test=ttest(index_Test);
            %Caricamento Automatico Dati
            Misura=['load Calcolo_k_Pattino_f' num2str(dforo) '_s' num2str(Sp) '_ps' num2str(ps) '_x' num2str(x0_precarico) '_' num2str(Test)];
            eval(Misura)
        end
    end
end

k_medi_f6_x0=[mean([k_f6_s50_ps4_x0_1 k_f6_s50_ps4_x0_2 k_f6_s50_ps4_x0_3]) mean([k_f6_s100_ps4_x0_1 k_f6_s100_ps4_x0_2 k_f6_s100_ps4_x0_3]) mean([k_f6_s120_ps4_x0_1 k_f6_s120_ps4_x0_2 k_f6_s120_ps4_x0_3]) mean([k_f6_s150_ps4_x0_1 k_f6_s150_ps4_x0_2 k_f6_s150_ps4_x0_3])];
k_medi_f8_x0=[mean([k_f8_s50_ps4_x0_1 k_f8_s50_ps4_x0_2 k_f8_s50_ps4_x0_3]) mean([k_f8_s100_ps4_x0_1 k_f8_s100_ps4_x0_2 k_f8_s100_ps4_x0_3]) mean([k_f8_s120_ps4_x0_1 k_f8_s120_ps4_x0_2 k_f8_s120_ps4_x0_3]) mean([k_f8_s150_ps4_x0_1 k_f8_s150_ps4_x0_2 k_f8_s150_ps4_x0_3])];
p_f6=polyfit(Sspessore,k_medi_f6_x0,4);
p_f8=polyfit(Sspessore,k_medi_f8_x0,4);
Spessore_f=linspace(Sspessore(1),Sspessore(end));
k_interp_f6=polyval(p_f6,Spessore_f);
k_interp_f8=polyval(p_f8,Spessore_f);

figure
plot(Sspessore(1),k_f6_s50_ps4_x0_1,'bo','Linewidth',4),hold on
plot(Sspessore(1),k_f6_s50_ps4_x0_2,'bo','Linewidth',4),hold on
plot(Sspessore(1),k_f6_s50_ps4_x0_3,'bo','Linewidth',4),hold on

plot(Sspessore(2),k_f6_s100_ps4_x0_1,'ro','Linewidth',4),hold on
plot(Sspessore(2),k_f6_s100_ps4_x0_2,'ro','Linewidth',4),hold on
plot(Sspessore(2),k_f6_s100_ps4_x0_3,'ro','Linewidth',4),hold on

plot(Sspessore(3),k_f6_s120_ps4_x0_1,'go','Linewidth',4),hold on
plot(Sspessore(3),k_f6_s120_ps4_x0_2,'go','Linewidth',4),hold on
plot(Sspessore(3),k_f6_s120_ps4_x0_3,'go','Linewidth',4),hold on

plot(Sspessore(4),k_f6_s150_ps4_x0_1,'ko','Linewidth',4),hold on
plot(Sspessore(4),k_f6_s150_ps4_x0_2,'ko','Linewidth',4),hold on
plot(Sspessore(4),k_f6_s150_ps4_x0_3,'ko','Linewidth',4),hold on

plot(Sspessore,k_medi_f6_x0,'kx','LineWidth',2)
plot(Spessore_f,k_interp_f6,'k--','LineWidth',2)
title('Confronto rigidezze pattino foro 6')
xlabel('$Spessore$ ($\mu m$)')
ylabel('$k$ ($\frac{N}{m}$)')
grid on

figure
plot(Sspessore(1),k_f8_s50_ps4_x0_1,'bo','Linewidth',4),hold on
plot(Sspessore(1),k_f8_s50_ps4_x0_2,'bo','Linewidth',4),hold on
plot(Sspessore(1),k_f8_s50_ps4_x0_3,'bo','Linewidth',4),hold on

plot(Sspessore(2),k_f8_s100_ps4_x0_1,'ro','Linewidth',4),hold on
plot(Sspessore(2),k_f8_s100_ps4_x0_2,'ro','Linewidth',4),hold on
plot(Sspessore(2),k_f8_s100_ps4_x0_3,'ro','Linewidth',4),hold on

plot(Sspessore(3),k_f8_s120_ps4_x0_1,'go','Linewidth',4),hold on
plot(Sspessore(3),k_f8_s120_ps4_x0_2,'go','Linewidth',4),hold on
plot(Sspessore(3),k_f8_s120_ps4_x0_3,'go','Linewidth',4),hold on

plot(Sspessore(4),k_f8_s150_ps4_x0_1,'ko','Linewidth',4),hold on
plot(Sspessore(4),k_f8_s150_ps4_x0_2,'ko','Linewidth',4),hold on
plot(Sspessore(4),k_f8_s150_ps4_x0_3,'ko','Linewidth',4),hold on

plot(Sspessore,k_medi_f8_x0,'kx','LineWidth',2)
plot(Spessore_f,k_interp_f8,'k--','LineWidth',2)
title('Confronto rigidezze pattino foro 8')
xlabel('$Spessore$ ($\mu m$)')
ylabel('$k$ ($\frac{N}{m}$)')
grid on